
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    int     i, j, p, numFactors, *power, len;
    char    *xString, *outString;
    poly    f, *factors, temp;
    string  inString;
    poly    pCheck, zCheck;
   
    // x^10 + 5x^8 - 3x^6 + 2x^3 - x^2 + x - 1 gives bad input
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    cout << endl;
    cin.ignore();  // needed for next cin with prompt to behave

    cout << "poly: ";
    getline(cin, inString);
    cout << endl;
    
    len = strlen(inString.c_str());
    xString = (char*)malloc((len+1)*sizeof(char));
    strcpy(xString, inString.c_str());
 
    if(!polyConvFromxString(f, xString))
    {
        cout << "bad input" << endl << endl;
        goto again;
    }
    
    if(f.array[f.deg]!=1)
    {
        cout << "The polynomial is not monic." << endl << endl;
        goto again;
    }
    
    if(f.deg==0)
    {
        cout << f.array[0].num % p << endl << endl;
        goto again;
    }
    
    polyFactorOverp(factors, numFactors, power, f, p);
    cout << "Irreducible Factors = " << numFactors << endl;
    for(i=0;i<numFactors;++i)
    {
        temp = factors[i];
        polyConvToxString(outString, temp);
        if(power[i]==1)
            cout << outString << endl;
        else
        {
            if(!(temp.deg==1 && temp.array[0]==0))
                cout << "(" << outString << ")^" << power[i] << endl;
            else
                cout << outString << "^" << power[i] << endl;
        }
        free(outString);
    }
    cout << endl;
    
    if(numFactors>1)
    {
        pCheck = 1;
        zCheck = 1;
        
        for(i=0;i<numFactors;++i)
        {
            for(j=0;j<power[i];++j)
            {
                pCheck = pCheck * factors[i] % p;
                zCheck = zCheck * factors[i];
            }
        }
        polyConvToxString(outString, pCheck);
        cout << "product over GF(p):" << endl;
        cout << outString << endl << endl;
        free(outString);
        
        polyConvToxString(outString, zCheck);
        cout << "product over Z:" << endl;
        cout << outString << endl << endl;
        
        free(outString);
    }
    cout << endl;
    
    goto again;
    
    return 0;
}
